//database_demo.c
library "PToolboxLib"
main() {
  pointer p;
  string data[7] = {"Bob","1","18","19840201","2315","Likes goat cheese.","6.12"};
  string dbName = "testDB";
  int i, dbType, numFields;

  clear();
  
  //For purpose of demo, delete the database if it already exists.
  if(DBopen(dbName)==0) DBrm(-1); 
  
  //create & load field information array
  p = Array("is,7,2");

  p[0][0]=1; //string
  p[0][1]="Name";
  
  p[1][0]=5; //boolean
  p[1][1]="Married";
 
  p[2][0]=2; //integer
  p[2][1]="Age";
 
  p[3][0]=8; //date
  p[3][1]="Date of Birth"; 

  p[4][0]=9; //time
  p[4][1]="Time of Birth";
  
  p[5][0]=12; //note
  p[5][1]="Info";
  
  p[6][0]=3; //float
  p[6][1]="Height";

  //Create the database
  //dbType = 1; //set database type to Pilot-DB
  dbType = 0; //set database type to HanDBase
  i=DBcreate(dbName,dbType,7,&p[0][0]); // &p[0][0] is pointer to start of array data
  if(i==-1) { 
    alert("HanDBase not installed");
  }
    
  i=DBopen(dbName);  
  if(i != 0) {
    alert("Failed to open database");
  }
  
    
  //Get number of fields
  numFields = DBinfo(1,0);
  puts("Field count="+numFields+"\n");
  for(i=0;i<numFields;i++) puts("Field "+i+" is type "+DBinfo(3,i)+"\n");
 
  //append a record
  DBsetrec(-1,data);
    
  //add a new record
  data[0]="Betty";
  data[6]="4.6";
  DBsetrec(-1,data);
  
  //modify first record
  data[0]="Jim";
  data[6]="6";
  DBsetrec(0,data);  
   
  //report number of records 
  puts("Num recs="+DBinfo(2,0)+"\n"); 

  //get contents of record 1
  DBgetrec(1,data);
  for(i=0;i<numFields;i++) puts(data[i]+"\n");

  //Move record 1 to position 0
  DBmoverec(1,0);
}